#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <ctime>
#include <cstring>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <bitset>
#include <stack>
#include <queue>
#include <deque>
#include <complex>

using namespace std;

#define pb push_back
#define mp make_pair
#define sz(s) int((s).size())
#define len(s) int((s).size())
#define all(s) (s).begin(), (s).end()
#ifdef _WIN32
#define LLD "%I64d"
#else
#define LLD "%lld"
#endif
#ifdef LOCAL42
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
#define eprintf(...) 42
#endif
#define y0 yy0
#define y1 yy1
#define next _next
#define prev _prev
#define rank _rank
#define link _link
#define hash _hash
#define fs first
#define sc second

typedef long long ll;
typedef long long llong;
typedef long long int64;
typedef unsigned int uint;
typedef long double ld;
typedef unsigned long long ull;
typedef unsigned long long ullong;
typedef unsigned long long lint;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int inf = int(1e9);
const double eps = 1e-9;
const double pi = 4 * atan(double(1));

struct vt
{
	double x, y;
	vt(double _x, double _y)
	{
		x = _x, y = _y;
	}
	friend vt operator +(vt a, vt b)
	{
		return vt(a.x + b.x, a.y + b.y);
	}
	friend vt operator -(vt a, vt b)
	{
		return vt(a.x - b.x, a.y - b.y);
	}
	friend double operator *(vt a, vt b)
	{
		return a.x * b.x + a.y * b.y;
	}
	friend double operator ^(vt a, vt b)
	{
		return a.x * b.y - b.x * a.y;
	}
	friend vt operator *(vt v, double k)
	{
		return vt(v.x * k, v.y * k);
	}
	friend vt operator /(vt v, double k)
	{
		return vt(v.x / k, v.y / k);
	}
	double abs()
	{
		return x * x + y * y;
	}
	friend vt operator ~(vt v)
	{
		return vt(-v.y, v.x);
	}
	vt(){}
};

vt inter(vt a, vt b, vt c, vt d)
{
	return (a * ((b - c) ^ (d - c)) + b * ((d - c) ^ (a - c))) / ((b - a) ^ (d - c));
}

vt symm(vt a, vt b, vt c)
{
	return a + (~(c - b)) * ((a - b) ^ (c - b)) / (c - b).abs() * 2.0;
};


struct some
{
	vt a, b;
	bool is_line;
	some(vt _a)
	{
		a = _a;
		is_line = false;
	}
	some(vt _a, vt _b)
	{
		a = _a;
		b = _b;
		is_line = true;
	}
	friend some operator +(some a, some b)
	{
		if (a.is_line && b.is_line)
			return some(inter(a.a, a.b, b.a, b.b));
		if (a.is_line && !b.is_line)
			return symm(b.a, a.a, a.b);
		if (b.is_line && !a.is_line)
			return symm(a.a, b.a, b.b);
		return some(a.a, b.a);
	}
};

const int N = 105;

char buf[N];
int pt = -1;

char tmp[N];

int toint(int l, int r)
{
	for (int i = l; i <= r; i++)
		tmp[i - l] = buf[i];
	tmp[r - l + 1] = 0;
	return atoi(tmp);
}

some get()
{
	if (buf[pt] >= '0' && buf[pt] <= '9')
	{
		int r = pt;
		int l = pt;
		while (l >= 0 && (buf[l] >= '0' && buf[l] <= '9') || buf[l] == '-')
			--l;
		assert(l >= 0 && buf[l] == ',');
		int y = toint(l + 1, r);
		r = l - 1;
		l = r;
		while (l >= 0 && (buf[l] >= '0' && buf[l] <= '9') || buf[l] == '-')
			--l;
		int x = toint(l + 1, r);
		pt = l;
		return some(vt(x, y));
	}
	--pt;
	some b = get();
	assert(pt >= 0 && buf[pt] == '(');
	--pt;
	if (pt >= 0 && buf[pt] == '@')
	{
		--pt;
		some a = get();
		return a + b;
	}
	return b;
}

bool solve()
{
	gets(buf);
	if (buf[0] == '#')
		return false;
	pt = strlen(buf) - 1;
	some ans = get();
	printf("%.8lf %.8lf\n", ans.a.x, ans.a.y);
	return true;
}

int main() {
#ifdef LOCAL42
#define TASK "H"
	freopen(TASK ".in", "r", stdin);
	freopen(TASK ".out", "w", stdout);
#else

#endif
	while (solve());
	return 0;
}
